<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="shortcut icon" href="/assets/gambar/logo.png" type="image/x-icon">
</head>
<body class="bg-light" style="background-image: url('/assets/gambar/backdrop.jpg'); background-size: cover; background-repeat: no-repeat; background-position: center; background-attachment: fixed;">

    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100">
            <div class="col-md-4">
                <div class="card shadow">
                    <div class="card-body">
                        <img src="/assets/gambar/logo.png" class="d-block mx-auto" width="70%" alt="" srcset="">
                        <h4 class="card-title text-center mb-4 mt-3">Selamat Datang di SIPIJAR</h4>

                        <form method="POST" action="">
                            <?php echo csrf_field(); ?>

                            <div class="mb-3">
                                <label for="nomor_induk" class="form-label">Nomor Induk</label>
                                <input type="text" name="nomor_induk" id="nomor_induk" class="form-control" value="<?php echo e(old('nomor_induk')); ?>" required autofocus>
                            </div>

                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" name="password" id="password" class="form-control" required>
                            </div>

                            <div class="mb-3 form-check">
                                <input type="checkbox" class="form-check-input" id="showPassword" onclick="togglePassword()">
                                <label class="form-check-label" for="showPassword">Show Password</label>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Sign In</button>
                            </div>
                        </form>

                        <p class="text-end mt-3 mb-0">
                            <small><a href="#">Lupa Password</a></small>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS (Optional) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
    function togglePassword() {
        const passwordInput = document.getElementById('password');
        passwordInput.type = passwordInput.type === 'password' ? 'text' : 'password';
    }
</script>
</body>
</html>
<?php /**PATH C:\Users\User\Documents\SIPIJAR\resources\views/login.blade.php ENDPATH**/ ?>