<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>SIPIJAR - Lupa Password</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap">
    <link rel="shortcut icon" href="/assets/gambar/logo.png" type="image/x-icon">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f4f6f9;
        }

        .card {
            border: none;
            border-radius: 12px;
        }

        .card-header {
            background-color: #0d6efd;
            color: #fff;
            border-radius: 12px 12px 0 0;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-5 col-lg-4">
                <div class="card shadow">
                    <div class="card-header text-center">
                        <h4 class="mb-0">Cari Akun</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('otp.send')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="induk" class="form-label">Nomor Induk :</label>
                                <input type="text" name="induk" id="induk" class="form-control" required autofocus>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Cari</button>
                            </div>
                        </form>
                        <div class="text-center mt-3">
                            <p>Sudah punya akun ? Silahkan <a href="/">Login</a></p>
                            
                        </div>
                    </div>
                </div>
                <p class="text-center mt-4 text-muted small">&copy; <?php echo e(date('Y')); ?> Sistem Informasi Pengelolaan Infrastruktur Jaringan</p>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->make('sweetalert::alert', ['cdn' => 'https://cdn.jsdelivr.net/npm/sweetalert2@11'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html><?php /**PATH D:\KAMPUS\SEMESTER 6\KP\aplikasi\SIPIJAR\resources\views/password/lupa.blade.php ENDPATH**/ ?>