

<?php $__env->startSection('title', 'SIPAJAR - Laporan Poligon'); ?>
<?php $__env->startSection('header', 'Laporan Poligon'); ?>
<?php $__env->startSection('konten'); ?>

    <div class="card">
        <div class="card-header">
            <div class="d-grip gap-2 d-md-flex justify-content-md-end">
                <form method="GET" action="<?php echo e(route('laporan.index')); ?>" class="d-flex justify-content-between">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-4 col-lg-4">
                            <div class="form-group">
                                <label for="branch">Branch :</label>
                                <select name="branch" id="branch" class="form-control">
                                    <option value="">-- Pilih Branch --</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($branch->id); ?>" <?php echo e($branch->id == request()->branch ? 'selected' : ''); ?>>
                                            <?php echo e($branch->nama); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-4 col-lg-4">
                            <div class="form-group">
                                <label for="status">Status :</label>
                                <select name="status" id="status" class="form-control">
                                    <option value="">-- Pilih Status --</option>
                                    <option value="review" <?php echo e(request()->status == 'review' ? 'selected' : ''); ?>>Review</option>
                                    <option value="revisi" <?php echo e(request()->status == 'revisi' ? 'selected' : ''); ?>>Revisi</option>
                                    <option value="approval" <?php echo e(request()->status == 'approval' ? 'selected' : ''); ?>>Approval</option>
                                    <option value="kendala" <?php echo e(request()->status == 'kendala' ? 'selected' : ''); ?>>Kendala</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-4 col-lg-4"><br>
                            <button type="submit" class="btn btn-primary me-md-2"><i class="bi bi-search"></i> Filter</button>
                        </div>
                    </div>
                </form>
            </div>
            
        </div>

        <div class="card-body">
            <!-- Menampilkan Data jika ada -->
            <?php if($data->isNotEmpty()): ?>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered" id="table1">
                        <thead>
                            <tr>
                                <th class="text-center">No</th>
                                <th class="text-center">Branch</th>
                                <th class="text-center">Nama Proyek</th>
                                <th class="text-center">Tipe Desain</th>
                                <th class="text-center">Total BoQ</th>
                                <th class="text-center">Mitra</th>
                                <th class="text-center">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($d->branch->nama ?? 'Branch Tidak Ditemukan'); ?></td>
                                    <td><?php echo e($d->nama); ?></td>
                                    <td><?php echo e($d->tipe); ?></td>
                                    <td><?php echo e(number_format($d->total_boq, 0, ',', '.')); ?></td>
                                    <td><?php echo e($d->user->nama ?? 'Mitra Tidak Ditemukan'); ?></td>
                                    <td><?php echo e(ucfirst($d->status)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Tombol Export -->
                <div class="mt-3 text-end">
                    <a href="<?php echo e(route('laporan.export', ['branch' => request('branch'), 'status' => request('status')])); ?>"
                        class="btn btn-success">
                        <i class="bi bi-file-spreadsheet-fill"></i> Export to Excel
                    </a>
                </div>
            <?php else: ?>
                <div class="alert alert-info mt-3">
                    Tidak ada data yang ditemukan. Silakan sesuaikan filter.
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\User\Documents\SIPIJAR\resources\views/main/laporan/laporan.blade.php ENDPATH**/ ?>