<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OTPController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\CatatanController;
use App\Http\Controllers\PoligonController;
use App\Http\Controllers\PenggunaController;
use App\Http\Controllers\PengaturanController;
use App\Http\Controllers\LaporanExcelController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [LoginController::class, 'index'])->name('login');
Route::post('/', [LoginController::class, 'auth']);
Route::get('/lupa-password', [OTPController::class, 'lupaAkun']);
Route::post('/lupa-password', [OTPController::class, 'sendOTP'])->name('otp.send');
Route::get('/lupa-password/otp/{uuid}', [OTPController::class, 'index'])->name('otp.index');
Route::post('/lupa-password/otp', [OTPController::class, 'verifyOTP'])->name('otp.verifikasi');
Route::middleware('auth')->group(function () {
    Route::prefix('main')->group(function () {
        Route::get('/', [AdminController::class, 'index'])->name('dashboard');
        Route::resource('pengaturan', PengaturanController::class);
        Route::prefix('order')->group(function () {
            Route::resource('branch', BranchController::class);
            Route::resource('poligon', PoligonController::class);
            Route::resource('catatan', CatatanController::class);
            Route::post('/poligon/update-status', [PoligonController::class, 'updateStatus'])->name('poligon.updateStatus');
        });
        Route::middleware('role:Admin')->group(function () {
            Route::resource('pengguna', PenggunaController::class);
        });
        Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
        Route::get('/file/{type}/{userId}/{filename}', [FileController::class, 'show'])->name('file.show');
        Route::get('/foto-profil/{userId}/{filename?}', [FileController::class, 'showProfileImage'])
        ->name('foto.profil');
        Route::get('/catatan/list/{id_poligon}', [CatatanController::class, 'list'])->name('catatan.list');
        Route::get('/laporan', [LaporanExcelController::class, 'index'])->name('laporan.index');
        Route::get('/laporan/export', [LaporanExcelController::class, 'exportManual'])->name('laporan.export');
    });
});