@extends('layout.layout')
@section('title', 'Lihat Data Poligon ' . $data['nama'])
@section('header', 'Lihat Data Poligon ' . $data['nama'])
@section('konten')
    <section id="basic-horizontal-layouts">
        <div class="row match-height">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="form-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <label for="branch">Branch</label>
                                </div>
                                <div class="col-md-8 form-group">
                                    <select name="branch" id="branch" class="form-select" disabled>
                                        <option value="">-- Pilih Branch --</option>
                                        @foreach ($branch as $b)
                                            <option value="{{ $b->id }}" {{ $data->id_branch == $b->id ? 'selected' : '' }}>{{ $b->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="nama">Nama Proyek</label>
                                </div>
                                <div class="col-md-8 form-group">
                                    <input type="text" name="nama" id="nama" class="form-control"
                                        placeholder="Masukkan Nama Proyek" value="{{ $data->nama }}" readonly>
                                </div>
                                <div class="col-md-4">
                                    <label for="tipe">Tipe Desain</label>
                                </div>
                                <div class="col-md-8 form-group">
                                    <select name="tipe" id="tipe" class="form-select" disabled>
                                        <option value="">-- Pilih Tipe Desain --</option>
                                        <option value="PT 3" {{ $data->tipe == 'PT 3' ? 'selected' : '' }}>PT 3</option>
                                        <option value="CSF" {{ $data->tipe == 'CSF' ? 'selected' : '' }}>CSF</option>
                                        <option value="FEEDER" {{ $data->tipe == 'FEEDER' ? 'selected' : '' }}>FEEDER</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label for="file_kml">File KML <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-8 form-group">
                                    <a href="{{ route('file.show', ['type' => 'kml', 'userId' => $data->id_user ?? $data->temp_id, 'filename' => basename($data->file_kml)]) }}" target="_blank">Download File KML</a>
                                </div>
                                <div class="col-md-4">
                                    <label for="file_boq">File BoQ <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-8 form-group">
                                    <a href="{{ route('file.show', ['type' => 'boq', 'userId' => $data->id_user ?? $data->temp_id, 'filename' => basename($data->file_boq)]) }}" target="_blank">Download File BoQ</a>
                                </div>
                                <div class="col-sm-12 d-flex justify-content-center">
                                    <a href="{{ route('poligon.index') }}" class="btn btn-danger me-1 mb-1">Kembali <i class="bi bi-arrow-left-circle-fill"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
