@extends('layout.layout')
@section('title', 'Edit Data Poligon ' . $data['nama'])
@section('header', 'Edit Data Poligon ' . $data['nama'])
@section('konten')
    <section id="basic-horizontal-layouts">
        <div class="row match-height">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <form id="myForm" action="{{ route('poligon.update', $data->id) }}" method="post" class="form form-horizontal" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="branch">Branch <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <select name="branch" id="branch" class="form-select" required>
                                            <option value="">-- Pilih Branch --</option>
                                            @foreach ($branch as $b)
                                                <option value="{{ $b->id }}" {{ $data->id_branch == $b->id ? 'selected' : '' ; }}>{{ $b->nama }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="nama">Nama Proyek <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="text" name="nama" id="nama" class="form-control" placeholder="Masukkan Nama Proyek" value="{{ $data->nama }}" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="tipe">Tipe Desain <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <select name="tipe" id="tipe" class="form-select" required>
                                            <option value="">-- Pilih Tipe Desain --</option>
                                            <option value="PT 3" {{ $data->tipe == 'PT 3' ? 'selected' : '' ; }}>PT 3</option>
                                            <option value="CSF"> {{ $data->tipe == 'CSF' ? 'selected' : '' ; }}CSF</option>
                                            <option value="FEEDER" {{ $data->tipe == 'FEEDER' ? 'selected' : '' ; }}>FEEDER</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="file_kml">File KML <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="file" name="file_kml" id="file_kml" class="form-control"
                                            accept=".kml,application/vnd.google-earth.kml+xml">
                                        <span>File sebelumnya : <a href="{{ route('file.show', ['type' => 'kml', 'userId' => ($data->id_user ?? $data->nama_user), 'filename' => basename($data->file_kml)]) }}" target="_blank">Download File KML</a></span>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="file_boq">File BoQ <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="file" name="file_boq" id="file_boq" class="form-control"
                                            accept=".xlsx,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
                                        <span>File sebelumnya : <a href="{{ route('file.show', ['type' => 'boq', 'userId' => ($data->id_user ?? $data->nama_user), 'filename' => basename($data->file_boq)]) }}" target="_blank">Download File BoQ</a></span>
                                    </div>
                                    <div class="col-sm-12 d-flex justify-content-center">
                                        <button type="submit" class="btn btn-primary me-1 mb-1">Submit  <i class="bi bi-send-fill"></i></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection