@extends('layout.layout')
@section('title', 'Edit Data Pengguna ' . $data['nama'])
@section('header', 'Edit Data Pengguna ' . $data['nama'])
@section('konten')
    <section id="basic-horizontal-layouts">
        <div class="row match-height">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <form id="myForm" action="{{ route('pengguna.update', $data->id) }}" method="post" class="form form-horizontal">
                            @csrf
                            @method('PUT')
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="nama">Nama Pengguna <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="text" name="nama" id="nama" class="form-control"
                                            placeholder="Masukkan Nama Pengguna" value="{{ $data->nama }}" required autofocus>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="nomor_induk">Nomor Induk <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="text" name="nomor_induk" id="nomor_induk" class="form-control"
                                            placeholder="Masukkan Nomor Induk" value="{{ $data->nomor_induk }}" required>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="email">Email</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="email" name="email" id="email" class="form-control"
                                            placeholder="Masukkan Email (Opsional)" value="{{ $data->email }}">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="password">Password</label>
                                        <small class="text-danger">Kosongkan jika tidak ingin dirubah</small>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <input type="text" name="password" id="password" class="form-control"
                                            placeholder="Masukkan Password (Opsional)">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="hak_akses">Hak akses <span class="text-danger">*</span></label>
                                    </div>
                                    <div class="col-md-8 form-group">
                                        <select name="hak_akses" id="hak_akses" class="form-select" required>
                                            <option value="">-- Pilih Hak Akses --</option>
                                            <option value="Admin" {{ $data->hak_akses == 'Admin' ? 'selected' : '' }}>Admin</option>
                                            <option value="Mitra" {{ $data->hak_akses == 'Mitra' ? 'selected' : '' }}>Mitra</option>
                                            <option value="SDI" {{ $data->hak_akses == 'SDI' ? 'selected' : '' }}>SDI</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-12 d-flex justify-content-center">
                                        <button type="submit" class="btn btn-primary me-1 mb-1">Simpan  <i class="bi bi-send-fill"></i></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection