@extends('layout.layout')
@section('title', 'SIPIJAR - Data Pengguna')
@section('header', 'Data Pengguna')
@section('konten')
    <div class="card">
        <div class="card-header">
            <div class="d-grip gap-2 d-md-flex justify-content-md-end">
                <a href="{{ route('pengguna.create') }}" class="btn btn-primary me-md-2"><i class="bi bi-plus-lg"></i> Tambah
                    Data</a>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered" id="table1">
                    <thead>
                        <tr>
                            <th class="text-center">No</th>
                            <th class="text-center">Nama Pengguna</th>
                            <th class="text-center">No Induk</th>
                            <th class="text-center">Email</th>
                            <th class="text-center">Hak Akses</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $no = 1;
                        @endphp
                        @foreach ($data as $d)
                            <tr>
                                <td class="text-center">{{ $no++ }}</td>
                                <td>{{ $d->nama }}</td>
                                <td>{{ $d->nomor_induk }}</td>
                                <td>{{ $d->email }}</td>
                                <td>{{ $d->hak_akses }}</td>
                                <td>
                                    @if (auth()->user()->id != $d->id) 
                                        <a href="{{ route('pengguna.edit', $d->id) }}" class="btn btn-success btn-sm m-1"><i
                                                class="bi bi-pencil-square"></i> Edit</a>
                                        <form onsubmit="return confirm('Apakah Anda Yakin ?');"
                                            action="{{ route('pengguna.destroy', $d->id) }}" method="POST" name="hapus">
                                            @method('DELETE')
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-danger m-1"><i class="bi bi-trash"></i>
                                                Delete</button>
                                        </form>
                                    @else
                                        Tidak dapat mengubah akun sendiri
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection