<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title')</title>
    @stack('meta')
    @livewireStyles
    <link rel="stylesheet" href="/assets/mazer/assets/extensions/datatables.net-bs5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" crossorigin href="/assets/mazer/assets/compiled/css/table-datatable-jquery.css">
    <link rel="stylesheet" crossorigin href="/assets/mazer/assets/compiled/css/app.css">
    <link rel="stylesheet" crossorigin href="/assets/mazer/assets/compiled/css/app-dark.css">
    <link rel="stylesheet" crossorigin href="/assets/mazer/assets/compiled/css/iconly.css">
    <link rel="shortcut icon" href="/assets/gambar/logo.png" type="image/x-icon">
    <style>
        #preloader {
            transition: opacity 0.5s ease;
        }
        #preloader.hidden {
            opacity: 0;
            pointer-events: none;
        }
        .notification-scrollable {
            max-height: 300px; /* Atur sesuai kebutuhan */
            overflow-y: auto;
        }
    </style>
    @yield('style')
</head>
<body>
    <script src="/assets/mazer/assets/static/js/initTheme.js"></script>
    <div id="preloader" style="position: fixed; top:0; left:0; width:100%; height:100%; background:white; z-index:9999; display:flex; justify-content:center; align-items:center;">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>
    <!-- Spinner Loading -->
    <div id="formLoader" style="
        position: fixed;
        top: 0; left: 0;
        width: 100%; height: 100%;
        background-color: rgba(255, 255, 255, 0.8);
        z-index: 9999;
        display: none;
        justify-content: center;
        align-items: center;
    ">
        <div class="spinner-border text-success" role="status"></div>
        <p class="mt-3">Sedang diproses...</p>
    </div>
    <div class="container-fluid">

        <div id="app">
            <div id="sidebar">
                <div class="sidebar-wrapper active">
                    <div class="sidebar-header position-relative">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="logo">
                                <a href="{{ route('dashboard') }}">
                                    <img src="/assets/gambar/logo.png" alt="Logo Admin" />
                                </a>
                            </div>
                            <div class="theme-toggle d-flex gap-2  align-items-center mt-2">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true"
                                    role="img" class="iconify iconify--system-uicons" width="20" height="20"
                                    preserveAspectRatio="xMidYMid meet" viewBox="0 0 21 21">
                                    <g fill="none" fill-rule="evenodd" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round">
                                        <path
                                            d="M10.5 14.5c2.219 0 4-1.763 4-3.982a4.003 4.003 0 0 0-4-4.018c-2.219 0-4 1.781-4 4c0 2.219 1.781 4 4 4zM4.136 4.136L5.55 5.55m9.9 9.9l1.414 1.414M1.5 10.5h2m14 0h2M4.135 16.863L5.55 15.45m9.899-9.9l1.414-1.415M10.5 19.5v-2m0-14v-2"
                                            opacity=".3"></path>
                                        <g transform="translate(-210 -1)">
                                            <path d="M220.5 2.5v2m6.5.5l-1.5 1.5"></path>
                                            <circle cx="220.5" cy="11.5" r="4"></circle>
                                            <path d="m214 5l1.5 1.5m5 14v-2m6.5-.5l-1.5-1.5M214 18l1.5-1.5m-4-5h2m14 0h2"></path>
                                        </g>
                                    </g>
                                </svg>
                                <div class="form-check form-switch fs-6">
                                    <input class="form-check-input  me-0" type="checkbox" id="toggle-dark" style="cursor: pointer">
                                    <label class="form-check-label"></label>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true"
                                    role="img" class="iconify iconify--mdi" width="20" height="20" preserveAspectRatio="xMidYMid meet"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="m17.75 4.09l-2.53 1.94l.91 3.06l-2.63-1.81l-2.63 1.81l.91-3.06l-2.53-1.94L12.44 4l1.06-3l1.06 3l3.19.09m3.5 6.91l-1.64 1.25l.59 1.98l-1.7-1.17l-1.7 1.17l.59-1.98L15.75 11l2.06-.05L18.5 9l.69 1.95l2.06.05m-2.28 4.95c.83-.08 1.72 1.1 1.19 1.85c-.32.45-.66.87-1.08 1.27C15.17 23 8.84 23 4.94 19.07c-3.91-3.9-3.91-10.24 0-14.14c.4-.4.82-.76 1.27-1.08c.75-.53 1.93.36 1.85 1.19c-.27 2.86.69 5.83 2.89 8.02a9.96 9.96 0 0 0 8.02 2.89m-1.64 2.02a12.08 12.08 0 0 1-7.8-3.47c-2.17-2.19-3.33-5-3.49-7.82c-2.81 3.14-2.7 7.96.31 10.98c3.02 3.01 7.84 3.12 10.98.31Z">
                                    </path>
                                </svg>
                            </div>
                            <div class="sidebar-toggler  x">
                                <a href="#" class="sidebar-hide d-xl-none d-block"><i class="bi bi-x bi-middle"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="sidebar-menu">
                        <ul class="menu">
                            <li class="sidebar-item {{ (request()->is('main')) ? 'active' : '' }}">
                                <a href="{{ route('dashboard') }}" class='sidebar-link'>
                                    <i class="bi bi-grid-fill"></i>
                                    <span>Dashboard</span>
                                </a>
                            </li>
                            @if(auth()->user()->hak_akses === 'Admin')
                                <li
                                    class="sidebar-item {{ (request()->is('main/pengguna') || request()->is('main/pengguna/*')) ? 'active' : '' }}">
                                    <a href="{{ route('pengguna.index') }}" class='sidebar-link'>
                                        <i class="bi bi-person-fill"></i>
                                        <span>Pengguna</span>
                                    </a>
                                </li>
                            @endif
                            <li
                                class="sidebar-item {{ (request()->is('main/order/poligon') || request()->is('main/order/poligon/*') || request()->is('main/order/branch') || request()->is('main/order/branch/*')) ? 'active' : '' }} has-sub" >
                                <a href="#" class='sidebar-link'>
                                    <i class="bi bi-circle-fill"></i>
                                    <span>Order</span>
                                </a>
                                <ul class="submenu {{ (request()->is('main/order/poligon') || request()->is('main/order/poligon/*') || request()->is('main/order/branch') || request()->is('main/order/branch/*')) ? 'active' : '' }}">
                                    <li class="submenu-item {{ (request()->is('main/order/poligon') || request()->is('main/order/poligon/*')) ? 'active' : '' }}">
                                        <a href="{{ route('poligon.index') }}" class="submenu-link">Data Poligon</a>
                                    </li>      
                                    @if(auth()->user()->hak_akses === 'Admin')          
                                        <li class="submenu-item {{ (request()->is('main/order/branch') || request()->is('main/order/branch/*')) ? 'active' : '' }}">
                                            <a href="{{ route('branch.index') }}" class="submenu-link">Data Branch</a>
                                        </li>               
                                    @endif                                           
                                </ul>
                            </li>
                            <li
                                class="sidebar-item  {{ (request()->is('main/laporan')) ? 'active' : '' }}">
                                <a href="{{ route('laporan.index') }}" class='sidebar-link'>
                                    <i class="bi bi-book-fill"></i>
                                    <span>Laporan Poligon</span>
                                </a>
                            </li>
                            <li
                                class="sidebar-item  {{ (request()->is('main/pengaturan')) ? 'active' : '' }}">
                                <a href="{{ route('pengaturan.index') }}" class='sidebar-link'>
                                    <i class="bi bi-gear-fill"></i>
                                    <span>Pengaturan Akun</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="main" class='layout-navbar navbar-fixed'>
                <header>
                    <nav class="navbar navbar-expand navbar-light navbar-top">
                        <div class="container-fluid">
                            <a href="#" class="burger-btn d-block">
                                <i class="bi bi-justify fs-3"></i>
                            </a>
    
                            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                                aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon"></span>
                            </button>
                            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <ul class="navbar-nav ms-auto mb-lg-0">
                                    @if (auth()->user()->hak_akses !== 'Mitra')
                                        <li class="nav-item dropdown me-3">
                                            <a class="nav-link active dropdown-toggle text-gray-600" href="#" data-bs-toggle="dropdown" data-bs-display="static" aria-expanded="false">
                                                <i class='bi bi-bell bi-sub fs-4'></i>
                                                @if ($notifikasi != 0)
                                                    <span class="badge badge-notification bg-danger">{{ $notifikasi }}</span>
                                                @endif
                                            </a>
                                            <ul class="dropdown-menu dropdown-menu-end notification-dropdown" aria-labelledby="dropdownMenuButton">
                                                <li class="dropdown-header">
                                                    <h6>Notifications</h6>
                                                </li>

                                                <div class="notification-scrollable px-1">
                                                    @if (!isset($notifikasi) || $notifikasi == 0)    
                                                        <li class="dropdown-item notification-item">
                                                            <a class="d-flex align-items-center" href="#">
                                                                <div class="notification-text ms-4">
                                                                    <p class="notification-title font-bold">Tidak ada notifikasi!</p>
                                                                </div>
                                                            </a>
                                                        </li>
                                                    @else
                                                        @isset($datapoligon)
                                                            @foreach ($datapoligon as $d)
                                                                <li class="dropdown-item notification-item">
                                                                    <a class="d-flex align-items-center" href="{{ route('poligon.index') }}">
                                                                        <div class="notification-text ms-4">
                                                                            <p class="notification-title font-bold">Informasi Poligon!</p>
                                                                            <p class="notification-subtitle font-thin text-sm">
                                                                                Mitra {{ $d->user->nama ?? $d->nama_user }} telah melakukan pengiriman data poligon
                                                                            </p>
                                                                        </div>
                                                                    </a>
                                                                </li>
                                                            @endforeach
                                                        @endisset
                                                    @endif
                                                </div>
                                            </ul>
                                        </li>
                                    @endif
                                </ul>
                                <div class="dropdown">
                                    <a href="#" data-bs-toggle="dropdown" aria-expanded="false">
                                        <div class="user-menu d-flex">
                                            <div class="user-name text-end me-3">
                                                <h6 class="mb-0 text-gray-600">{{ auth()->user()->nama }}</h6>
                                                <p class="mb-0 text-sm text-gray-600">{{ auth()->user()->hak_akses }}</p>
                                            </div>
                                            <div class="user-img d-flex align-items-center">
                                                <div class="avatar avatar-md">
                                                    <img src="
                                                        {{ route('foto.profil', ['userId' => auth()->user()->id, 'filename' => basename(auth()->user()->foto)]) }}">
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownMenuButton" style="min-width: 11rem;">
                                        <li>
                                            <h6 class="dropdown-header">Hello, {{ auth()->user()->nama }}!</h6>
                                        </li>
                                        <li><a class="dropdown-item" href="{{ route('pengaturan.index') }}"><i class="icon-mid bi bi-gear me-2"></i>
                                                Pengaturan Akun</a></li>
                                            <hr class="dropdown-divider">
                                        </li>
                                        <li><a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault();document.getElementById('logout-admin').submit();">
                                            <form action="{{ route('logout') }}" method="POST" id="logout-admin">
                                                @csrf
                                            </form>
                                            <i class="icon-mid bi bi-box-arrow-left me-2"></i> 
                                            Logout
                                            </a>
                                            
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </nav>
                </header>
                <div id="main-content">
                    <div class="page-heading">
                        <div class="page-title">
                            <div class="row">
                                <div class="col-12 col-md-6 order-md-1 order-last">
                                    <h3>@yield('header')</h3>
                                </div>
                            </div>
                        </div>
                        <section class="section">
                            @yield('konten')
                        </section>
                    </div>
                </div>
                <footer>
                    <div class="footer clearfix mb-0 text-muted">
                        <div class="float-start">
                            <p>2025 &copy; Indra Mulyanto</p>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
    </div>

    <script src="/assets/mazer/assets/extensions/jquery/jquery.min.js"></script>
    <script src="/assets/mazer/assets/static/js/components/dark.js"></script>
    <script src="/assets/mazer/assets/extensions/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="/assets/mazer/assets/compiled/js/app.js"></script>
    <script src="/assets/mazer/assets/extensions/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="/assets/mazer/assets/extensions/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
    <script src="/assets/mazer/assets/static/js/pages/datatables.js"></script>
    @stack('script')
    @livewireScripts
    @include('sweetalert::alert')
    <script>
        $.ajaxSetup({
            headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        window.addEventListener('load', function () {
            let preloader = document.getElementById('preloader');
            if (preloader) {
                preloader.classList.add('hidden');
                setTimeout(() => preloader.remove(), 500); // optional: remove from DOM
            }
        });
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('myForm'); // sesuaikan id form
            const loader = document.getElementById('formLoader');

            if (form && loader) {
                form.addEventListener('submit', function () {
                    loader.style.display = 'flex'; // tampilkan spinner
                });
            }
        });
    </script>
</body>
</html>
