<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Kode OTP</title>
    <style>
        body{
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 30px auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #1a73e8;
            color: white;
            text-align: center;
            padding: 20px;
            border-radius: 8px 8px 0 0;
        }

        .header h2 {
            margin: 0;
        }

        .content {
            padding: 20px;
            text-align: center;
        }

        .otp {
            font-size: 36px;
            color: #1a73e8;
            font-weight: bold;
            margin: 20px 0;
        }

        .note {
            font-size: 14px;
            color: #555;
        }

        .link {
            display: inline-block;
            margin-top: 20px;
            background-color: #28a745;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
        }

        .link:hover {
            background-color: #218838;
        }

        .footer {
            text-align: center;
            font-size: 12px;
            color: #888;
            margin-top: 30px;
        }

        .footer small{
            color : #bbb;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Kode OTP Ubah Password Akun</h2>
        </div>
        <div class="content">
            <p>Berikut kode OTP Anda:</p>
            <div class="otp">{{ $otp }}</div>
            <p class="note">Kode ini berlaku selama <strong>10 menit</strong>.</p>
            <a href="{{ $link }}" class="link">Verifikasi Akun</a>
        </div>
        <div class="footer">
            <hr>
            <small>&copy; {{ date('Y') }} Sistem Informasi Pengelolaan Infrastruktur Jaringan</small>
        </div>
    </div>
</body>
</html>