@extends('layout.layout')
@section('title', 'SIPIJAR - Dashboard')
@section('style')
    <style>
        td:hover {
            background-color: #cce5ff;
            cursor: pointer;
        }
        </style>
@endsection
@section('header', 'Dashboard')
@section('konten')
    <section class="section">
        <div class="card">
            <div class="card-body">

                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th rowspan="2" class="text-center bg-primary text-light" style="font-size:10px;">Telkom Akses Branch</th>
                            <th colspan="3" class="text-center bg-primary text-light" style="font-size:10px;">Total</th>
                            <th colspan="3" class="text-center bg-info text-dark" style="font-size:10px;">Review SDI</th>
                            <th colspan="3" class="text-center bg-warning text-dark" style="font-size:10px;">Revision Mitra</th>
                            <th colspan="3" class="text-center bg-success text-light" style="font-size:10px;">Approval SDI</th>
                            <th colspan="3" class="text-center bg-danger text-light" style="font-size:10px;">Kendala</th>
                        </tr>
                        <tr>
                            <th class="text-center bg-primary text-light" style="font-size:10px;">LOP</th>
                            <th class="text-center bg-primary text-light" style="font-size:10px;">Port</th>
                            <th class="text-center bg-primary text-light" style="font-size:10px;">BOQ (jt)</th>
                            <th class="text-center bg-info text-dark" style="font-size:10px;">LOP</th>
                            <th class="text-center bg-info text-dark" style="font-size:10px;">Port</th>
                            <th class="text-center bg-info text-dark" style="font-size:10px;">BOQ (jt)</th>
                            <th class="text-center bg-warning text-dark" style="font-size:10px;">LOP</th>
                            <th class="text-center bg-warning text-dark" style="font-size:10px;">Port</th>
                            <th class="text-center bg-warning text-dark" style="font-size:10px;">BOQ (jt)</th>
                            <th class="text-center bg-success text-light" style="font-size:10px;">LOP</th>
                            <th class="text-center bg-success text-light" style="font-size:10px;">Port</th>
                            <th class="text-center bg-success text-light" style="font-size:10px;">BOQ (jt)</th>
                            <th class="text-center bg-danger text-light" style="font-size:10px;">LOP</th>
                            <th class="text-center bg-danger text-light" style="font-size:10px;">Port</th>
                            <th class="text-center bg-danger text-light" style="font-size:10px;">BOQ (jt)</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($data as $d)
                            <tr>
                                <td colspan="1" class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id]) }}">{{ $d->nama}}</a></td>
                                <!-- Total -->
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id]) }}">{{ $d->total_lop }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id]) }}">{{ $d->total_port * 8 }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id]) }}">{{ number_format($d->total_boq, 0, ',', '.') }}</a></td>
                                <!-- Review -->
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'review']) }}">{{ $d->total_review_lop }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'review']) }}">{{ $d->total_review_port * 8 }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'review']) }}">{{ number_format($d->total_review_boq, 0, ',', '.') }}</a></td>
                                <!-- Revisi -->
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'revisi']) }}">{{ $d->total_revisi_lop }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'revisi']) }}">{{ $d->total_revisi_port * 8 }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'revisi']) }}">{{ number_format($d->total_revisi_boq, 0, ',', '.') }}</a></td>
                                <!-- Approval -->
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'approval']) }}">{{ $d->total_approval_lop }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'approval']) }}">{{ $d->total_approval_port * 8 }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'approval']) }}">{{ number_format($d->total_approval_boq, 0, ',', '.') }}</a></td>
                                <!-- Kendala -->
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'kendala']) }}">{{ $d->total_kendala_lop }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'kendala']) }}">{{ $d->total_kendala_port * 8 }}</a></td>
                                <td class="text-center" style="font-size:10px;"><a href="{{ route('poligon.index', ['branch' => $d->id, 'status' => 'kendala']) }}">{{ number_format($d->total_kendala_boq, 0, ',', '.') }}</a></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </section>
@endsection