<?php

namespace App\Providers;

use App\Models\Poligon;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        View::composer('layout.layout', function($view) {
            $datapoligon = Poligon::where('status', 'review')->get();
            $notifikasi = $datapoligon->count();
            $view->with([
                'datapoligon'       => $datapoligon,
                'notifikasi'        => $notifikasi,
            ]);
        });
    }
}
