<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Contracts\Queue\ShouldQueue;

class InformasiAkunMail extends Mailable
{
    use Queueable, SerializesModels;

    public $username;
    public $password;
    public $nama;

    /**
     * create a new message instance
     * @param string $username
     * @param string $password
     * @param string $nama
     */

    /**
     * Create a new message instance.
     */
    public function __construct($username, $password, $nama)
    {
        $this->username = $username;
        $this->password = $password;
        $this->nama = $nama;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Informasi Akun SIPIJAR Anda',
            from : new Address('indra.mulyanto11@gmail.com', 'Sistem Informasi Pengelolaan Infrastruktur Jaringan')
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.akun',
            with: [
                'username'  => $this->username,
                'password'  => $this->password,
                'nama'      => $this->nama,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
