<?php

namespace App\Livewire;

use App\Models\Poligon;
use Livewire\Component;

class StatusUpdater extends Component
{
    public $poligonId;
    public $status;

    public function mount($poligonId, $initialStatus)
    {
        $this->poligonId = $poligonId;
        $this->status = $initialStatus;
    }
    public function updatedStatus($value)
    {
        $allowedStatuses = ['review', 'revisi', 'approval', 'kendala'];
        if (!in_array($value, $allowedStatuses)) {
            return;
        }

        $poligon = Poligon::find($this->poligonId);
        if ($poligon) {
            $poligon->status = $value;
            $poligon->save();
            session()->flash('message', 'Status berhasil diupdate.');
        }
    }
    public function render()
    {
        return view('livewire.status-updater');
    }
}
