<?php

namespace App\Imports;

use App\Models\Poligon;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class PoligonImport implements ToCollection
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function collection(Collection $rows)
    {
        // Ambil isi sel
        $rawBoq  = $rows[284][6] ?? null; // G285 = baris 285 (index 284), kolom G = index 6
        $rawPort = $rows[72][6]  ?? null; // G73  = baris 73  (index 72),  kolom G = index 6

        // Bersihkan dan validasi nilai
        $cleanedBoq = preg_replace('/\D/', '', $rawBoq); // Ambil angka saja
        $boqValue = is_numeric($cleanedBoq) ? (int) substr($cleanedBoq, 0, 4) : 0;

        $cleanedPort = preg_replace('/\D/', '', $rawPort);
        $portValue = is_numeric($cleanedPort) ? (int) $cleanedPort : 0;

        // Simpan hanya jika keduanya angka
        if ($boqValue > 0 || $portValue > 0) {
            Poligon::create([
                'total_boq'  => $boqValue,
                'total_port' => $portValue,
            ]);
        }
    }
}
