<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('login');
    }

    public function auth(Request $request)
    {
        // Validasi input
        $credentials = $request->validate([
            'nomor_induk'   => 'required|string',
            'password'  => 'required|string',
        ],[
            'nomor_induk.required'  => 'No induk harus diisi!',
            'password.required' => 'Password harus diisi!',
        ]);

        if (Auth::attempt($credentials)) {
            // Jika login berhasil, regenerate session supaya aman
            $request->session()->regenerate();

            // Redirect ke halaman dashboard atau halaman setelah login
            return redirect()->route('dashboard')->withSuccess('Anda berhasil login');
        }

        // Jika gagal login, kembali ke halaman login dengan error
        return back()->withErrors([
            'username' => 'Username atau password salah.',
        ])->onlyInput('username');
    }

    public function logout(Request $request){
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('login')->with('success', 'Anda Berhasil Logout');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
