<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = Branch::withCount([
            'poligon as total_review_lop' => function ($query) {
                $query->where('status', 'review');
            },
            'poligon as total_approval_lop' => function ($query) {
                $query->where('status', 'approval');
            },
            'poligon as total_kendala_lop' => function ($query) {
                $query->where('status', 'kendala');
            },
            'poligon as total_revisi_lop' => function ($query) {
                $query->where('status', 'revisi');
            },
            'poligon as total_lop'
        ])
        ->withSum([
            'poligon as total_review_port' => fn($q) => $q->where('status', 'review'),
            'poligon as total_approval_port' => fn($q) => $q->where('status', 'approval'),
            'poligon as total_kendala_port' => fn($q) => $q->where('status', 'kendala'),
            'poligon as total_revisi_port' => fn($q) => $q->where('status', 'revisi'),
            'poligon as total_port'
        ], 'total_port')
        ->withSum([
            'poligon as total_review_boq' => fn($q) => $q->where('status', 'review'),
            'poligon as total_approval_boq' => fn($q) => $q->where('status', 'approval'),
            'poligon as total_kendala_boq' => fn($q) => $q->where('status', 'kendala'),
            'poligon as total_revisi_boq' => fn($q) => $q->where('status', 'revisi'),
            'poligon as total_boq'
        ], 'total_boq')
        ->get();


        return view('dashboard', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
