<?php

namespace App\Exports;

use App\Models\Poligon;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class PoligonExport implements FromView
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public $branch;
    public $status;

    public function __construct($branch, $status)
    {
        $this->branch = $branch;
        $this->status = $status;
    }

    public function view(): View
    {
        $query = Poligon::query();

        if ($this->branch) {
            $query->where('id_branch', $this->branch);
        }

        if ($this->status) {
            $query->where('status', $this->status);
        }

        $data = $query->with('branch', 'user')->get();

        // Kirim data ke view 'exports.poligon'
        return view('main.laporan.export.excel', compact('data'));
    }
}
